package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class DatasetImageStats(
    total: Option[Integer] = None,
    labeled: Option[Integer] = None,
    normal: Option[Integer] = None,
    anomaly: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats = {
    import DatasetImageStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Integer))(_.total)
      .optionallyWith(labeled.map(value => value: java.lang.Integer))(_.labeled)
      .optionallyWith(normal.map(value => value: java.lang.Integer))(_.normal)
      .optionallyWith(anomaly.map(value => value: java.lang.Integer))(_.anomaly)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly =
    zio.aws.lookoutvision.model.DatasetImageStats.wrap(buildAwsValue())
}
object DatasetImageStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DatasetImageStats =
      zio.aws.lookoutvision.model.DatasetImageStats(
        total.map(value => value),
        labeled.map(value => value),
        normal.map(value => value),
        anomaly.map(value => value)
      )
    def total: Option[Integer]
    def labeled: Option[Integer]
    def normal: Option[Integer]
    def anomaly: Option[Integer]
    def getTotal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("total", total)
    def getLabeled: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("labeled", labeled)
    def getNormal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("normal", normal)
    def getAnomaly: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("anomaly", anomaly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats
  ) extends zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly {
    override val total: Option[Integer] =
      scala.Option(impl.total()).map(value => value: Integer)
    override val labeled: Option[Integer] =
      scala.Option(impl.labeled()).map(value => value: Integer)
    override val normal: Option[Integer] =
      scala.Option(impl.normal()).map(value => value: Integer)
    override val anomaly: Option[Integer] =
      scala.Option(impl.anomaly()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetImageStats
  ): zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly = new Wrapper(impl)
}
