package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProjectResponse(
    projectMetadata: Option[zio.aws.lookoutvision.model.ProjectMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse
      .builder()
      .optionallyWith(projectMetadata.map(value => value.buildAwsValue()))(
        _.projectMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly =
    zio.aws.lookoutvision.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.CreateProjectResponse =
      zio.aws.lookoutvision.model
        .CreateProjectResponse(projectMetadata.map(value => value.asEditable))
    def projectMetadata
        : Option[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly]
    def getProjectMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("projectMetadata", projectMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse
  ) extends zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly {
    override val projectMetadata
        : Option[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly] = scala
      .Option(impl.projectMetadata())
      .map(value => zio.aws.lookoutvision.model.ProjectMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateProjectResponse
  ): zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
