package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{S3KeyPrefix, S3BucketName}
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucket: S3BucketName,
    prefix: Option[S3KeyPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.S3Location
      .builder()
      .bucket(S3BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        prefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.S3Location.ReadOnly =
    zio.aws.lookoutvision.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.S3Location =
      zio.aws.lookoutvision.model.S3Location(bucket, prefix.map(value => value))
    def bucket: S3BucketName
    def prefix: Option[S3KeyPrefix]
    def getBucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.S3Location
  ) extends zio.aws.lookoutvision.model.S3Location.ReadOnly {
    override val bucket: S3BucketName =
      zio.aws.lookoutvision.model.primitives.S3BucketName(impl.bucket())
    override val prefix: Option[S3KeyPrefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.lookoutvision.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.S3Location
  ): zio.aws.lookoutvision.model.S3Location.ReadOnly = new Wrapper(impl)
}
