package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{S3ObjectKey, S3BucketName}
import scala.jdk.CollectionConverters._
final case class OutputS3Object(bucket: S3BucketName, key: S3ObjectKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.OutputS3Object = {
    import OutputS3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.OutputS3Object
      .builder()
      .bucket(S3BucketName.unwrap(bucket): java.lang.String)
      .key(S3ObjectKey.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.OutputS3Object.ReadOnly =
    zio.aws.lookoutvision.model.OutputS3Object.wrap(buildAwsValue())
}
object OutputS3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.OutputS3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.OutputS3Object =
      zio.aws.lookoutvision.model.OutputS3Object(bucket, key)
    def bucket: S3BucketName
    def key: S3ObjectKey
    def getBucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3ObjectKey] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.OutputS3Object
  ) extends zio.aws.lookoutvision.model.OutputS3Object.ReadOnly {
    override val bucket: S3BucketName =
      zio.aws.lookoutvision.model.primitives.S3BucketName(impl.bucket())
    override val key: S3ObjectKey =
      zio.aws.lookoutvision.model.primitives.S3ObjectKey(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.OutputS3Object
  ): zio.aws.lookoutvision.model.OutputS3Object.ReadOnly = new Wrapper(impl)
}
