package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ModelArn,
  ModelVersion,
  DateTime,
  ModelStatusMessage,
  ModelDescriptionMessage
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModelMetadata(
    creationTimestamp: Option[DateTime] = None,
    modelVersion: Option[ModelVersion] = None,
    modelArn: Option[ModelArn] = None,
    description: Option[ModelDescriptionMessage] = None,
    status: Option[zio.aws.lookoutvision.model.ModelStatus] = None,
    statusMessage: Option[ModelStatusMessage] = None,
    performance: Option[zio.aws.lookoutvision.model.ModelPerformance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelMetadata = {
    import ModelMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelMetadata
      .builder()
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        description.map(value =>
          ModelDescriptionMessage.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ModelStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(performance.map(value => value.buildAwsValue()))(
        _.performance
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ModelMetadata.ReadOnly =
    zio.aws.lookoutvision.model.ModelMetadata.wrap(buildAwsValue())
}
object ModelMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelMetadata =
      zio.aws.lookoutvision.model.ModelMetadata(
        creationTimestamp.map(value => value),
        modelVersion.map(value => value),
        modelArn.map(value => value),
        description.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        performance.map(value => value.asEditable)
      )
    def creationTimestamp: Option[DateTime]
    def modelVersion: Option[ModelVersion]
    def modelArn: Option[ModelArn]
    def description: Option[ModelDescriptionMessage]
    def status: Option[zio.aws.lookoutvision.model.ModelStatus]
    def statusMessage: Option[ModelStatusMessage]
    def performance
        : Option[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly]
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDescription: ZIO[Any, AwsError, ModelDescriptionMessage] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.lookoutvision.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ModelStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPerformance: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPerformance.ReadOnly
    ] = AwsError.unwrapOptionField("performance", performance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelMetadata
  ) extends zio.aws.lookoutvision.model.ModelMetadata.ReadOnly {
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val modelVersion: Option[ModelVersion] = scala
      .Option(impl.modelVersion())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelVersion(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelArn(value))
    override val description: Option[ModelDescriptionMessage] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelDescriptionMessage(value)
      )
    override val status: Option[zio.aws.lookoutvision.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.lookoutvision.model.ModelStatus.wrap(value))
    override val statusMessage: Option[ModelStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelStatusMessage(value)
      )
    override val performance
        : Option[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly] = scala
      .Option(impl.performance())
      .map(value => zio.aws.lookoutvision.model.ModelPerformance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelMetadata
  ): zio.aws.lookoutvision.model.ModelMetadata.ReadOnly = new Wrapper(impl)
}
