package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{PaginationToken, DatasetEntry}
import scala.jdk.CollectionConverters._
final case class ListDatasetEntriesResponse(
    datasetEntries: Option[Iterable[DatasetEntry]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse = {
    import ListDatasetEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse
      .builder()
      .optionallyWith(
        datasetEntries.map(value =>
          value.map { item =>
            DatasetEntry.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetEntries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListDatasetEntriesResponse.wrap(buildAwsValue())
}
object ListDatasetEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListDatasetEntriesResponse =
      zio.aws.lookoutvision.model.ListDatasetEntriesResponse(
        datasetEntries.map(value => value),
        nextToken.map(value => value)
      )
    def datasetEntries: Option[List[DatasetEntry]]
    def nextToken: Option[PaginationToken]
    def getDatasetEntries: ZIO[Any, AwsError, List[DatasetEntry]] =
      AwsError.unwrapOptionField("datasetEntries", datasetEntries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse
  ) extends zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly {
    override val datasetEntries: Option[List[DatasetEntry]] = scala
      .Option(impl.datasetEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutvision.model.primitives.DatasetEntry(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse
  ): zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly =
    new Wrapper(impl)
}
