package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectAnomalyResult(
    source: Option[zio.aws.lookoutvision.model.ImageSource] = None,
    isAnomalous: Option[Boolean] = None,
    confidence: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult = {
    import DetectAnomalyResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(isAnomalous.map(value => value: java.lang.Boolean))(
        _.isAnomalous
      )
      .optionallyWith(confidence.map(value => value: java.lang.Float))(
        _.confidence
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly =
    zio.aws.lookoutvision.model.DetectAnomalyResult.wrap(buildAwsValue())
}
object DetectAnomalyResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DetectAnomalyResult =
      zio.aws.lookoutvision.model.DetectAnomalyResult(
        source.map(value => value.asEditable),
        isAnomalous.map(value => value),
        confidence.map(value => value)
      )
    def source: Option[zio.aws.lookoutvision.model.ImageSource.ReadOnly]
    def isAnomalous: Option[Boolean]
    def confidence: Option[Float]
    def getSource
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.ImageSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getIsAnomalous: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAnomalous", isAnomalous)
    def getConfidence: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ) extends zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly {
    override val source
        : Option[zio.aws.lookoutvision.model.ImageSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.lookoutvision.model.ImageSource.wrap(value))
    override val isAnomalous: Option[Boolean] =
      scala.Option(impl.isAnomalous()).map(value => value: Boolean)
    override val confidence: Option[Float] =
      scala.Option(impl.confidence()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomalyResult
  ): zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly = new Wrapper(
    impl
  )
}
