package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectAnomaliesResponse(
    detectAnomalyResult: Option[
      zio.aws.lookoutvision.model.DetectAnomalyResult
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse = {
    import DetectAnomaliesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse
      .builder()
      .optionallyWith(detectAnomalyResult.map(value => value.buildAwsValue()))(
        _.detectAnomalyResult
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly =
    zio.aws.lookoutvision.model.DetectAnomaliesResponse.wrap(buildAwsValue())
}
object DetectAnomaliesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DetectAnomaliesResponse =
      zio.aws.lookoutvision.model.DetectAnomaliesResponse(
        detectAnomalyResult.map(value => value.asEditable)
      )
    def detectAnomalyResult
        : Option[zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly]
    def getDetectAnomalyResult: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly
    ] = AwsError.unwrapOptionField("detectAnomalyResult", detectAnomalyResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse
  ) extends zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly {
    override val detectAnomalyResult
        : Option[zio.aws.lookoutvision.model.DetectAnomalyResult.ReadOnly] =
      scala
        .Option(impl.detectAnomalyResult())
        .map(value =>
          zio.aws.lookoutvision.model.DetectAnomalyResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesResponse
  ): zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly = new Wrapper(
    impl
  )
}
