package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.ModelArn
import scala.jdk.CollectionConverters._
final case class DeleteModelResponse(modelArn: Option[ModelArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse = {
    import DeleteModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly =
    zio.aws.lookoutvision.model.DeleteModelResponse.wrap(buildAwsValue())
}
object DeleteModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DeleteModelResponse =
      zio.aws.lookoutvision.model
        .DeleteModelResponse(modelArn.map(value => value))
    def modelArn: Option[ModelArn]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse
  ) extends zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly {
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteModelResponse
  ): zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
