package zio.aws.lookoutvision
import zio.aws.lookoutvision.model.UntagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.lookoutvision.{
  LookoutVisionAsyncClientBuilder,
  LookoutVisionAsyncClient
}
import zio.aws.lookoutvision.model.{
  CreateDatasetRequest,
  CreateProjectRequest,
  StartModelPackagingJobRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DeleteProjectRequest,
  ListModelsRequest,
  ListDatasetEntriesRequest,
  StopModelRequest,
  DeleteDatasetRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  DetectAnomaliesRequest,
  UpdateDatasetEntriesRequest,
  ListModelPackagingJobsRequest,
  DescribeModelPackagingJobRequest,
  DeleteModelRequest,
  StartModelRequest,
  DescribeProjectRequest,
  TagResourceRequest
}
import zio.aws.lookoutvision.model.primitives.DatasetEntry
import software.amazon.awssdk.services.lookoutvision.model.{
  DescribeProjectResponse,
  DescribeDatasetResponse,
  DetectAnomaliesResponse,
  StartModelResponse,
  ListProjectsResponse,
  StartModelPackagingJobResponse,
  CreateDatasetResponse,
  ListDatasetEntriesResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteModelResponse,
  ModelMetadata,
  CreateProjectResponse,
  ProjectMetadata,
  ModelPackagingJobMetadata,
  DeleteDatasetResponse,
  ListModelsResponse,
  CreateModelResponse,
  StopModelResponse,
  DescribeModelResponse,
  UpdateDatasetEntriesResponse,
  TagResourceResponse,
  DescribeModelPackagingJobResponse,
  DeleteProjectResponse,
  ListModelPackagingJobsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait LookoutVision extends AspectSupport[LookoutVision] {
  val api: LookoutVisionAsyncClient
  def listDatasetEntries(
      request: ListDatasetEntriesRequest
  ): ZStream[Any, AwsError, DatasetEntry]
  def listDatasetEntriesPaginated(request: ListDatasetEntriesRequest): IO[
    AwsError,
    zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly
  ]
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly]
  def listModels(
      request: ListModelsRequest
  ): ZStream[Any, AwsError, zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]
  def listModelsPaginated(
      request: ListModelsRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly]
  def createModel(
      request: CreateModelRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly]
  def updateDatasetEntries(request: UpdateDatasetEntriesRequest): IO[
    AwsError,
    zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly
  ]
  def describeDataset(
      request: DescribeDatasetRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly]
  def listProjects(request: ListProjectsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
  ]
  def listProjectsPaginated(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly]
  def deleteModel(
      request: DeleteModelRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly]
  def stopModel(
      request: StopModelRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.StopModelResponse.ReadOnly]
  def describeModelPackagingJob(request: DescribeModelPackagingJobRequest): IO[
    AwsError,
    zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly
  ]
  def startModelPackagingJob(request: StartModelPackagingJobRequest): IO[
    AwsError,
    zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, ReadOnly]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly]
  def startModel(
      request: StartModelRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.StartModelResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.lookoutvision.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeProject(
      request: DescribeProjectRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.TagResourceResponse.ReadOnly]
  def detectAnomalies(
      request: DetectAnomaliesRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly]
  def deleteDataset(
      request: DeleteDatasetRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DeleteDatasetResponse.ReadOnly]
  def listModelPackagingJobs(request: ListModelPackagingJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
  ]
  def listModelPackagingJobsPaginated(
      request: ListModelPackagingJobsRequest
  ): IO[
    AwsError,
    zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly
  ]
  def deleteProject(
      request: DeleteProjectRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly]
  def describeModel(
      request: DescribeModelRequest
  ): IO[AwsError, zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly]
}
object LookoutVision {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LookoutVision] = customized(
    identity
  )
  def customized(
      customization: LookoutVisionAsyncClientBuilder => LookoutVisionAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LookoutVision] = managed(
    customization
  ).toLayer
  def managed(
      customization: LookoutVisionAsyncClientBuilder => LookoutVisionAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, LookoutVision] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = LookoutVisionAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LookoutVisionAsyncClient, LookoutVisionAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        LookoutVisionAsyncClient,
        LookoutVisionAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new LookoutVisionImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LookoutVisionImpl[R](
      override val api: LookoutVisionAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LookoutVision
      with AwsServiceBase[R] {
    override val serviceName: String = "LookoutVision"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LookoutVisionImpl[R1] = new LookoutVisionImpl(api, newAspect, r)
    def listDatasetEntries(
        request: ListDatasetEntriesRequest
    ): ZStream[Any, AwsError, DatasetEntry] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest,
      ListDatasetEntriesResponse,
      java.lang.String
    ](
      "listDatasetEntries",
      api.listDatasetEntries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetEntries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutvision.model.primitives.DatasetEntry(item))
      .provideEnvironment(r)
    def listDatasetEntriesPaginated(request: ListDatasetEntriesRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest,
      ListDatasetEntriesResponse
    ]("listDatasetEntries", api.listDatasetEntries)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.ListDatasetEntriesResponse.wrap)
      .provideEnvironment(r)
    def createDataset(request: CreateDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest,
      CreateDatasetResponse
    ]("createDataset", api.createDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.CreateDatasetResponse.wrap)
      .provideEnvironment(r)
    def listModels(request: ListModelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest,
      ListModelsResponse,
      ModelMetadata
    ](
      "listModels",
      api.listModels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.models().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutvision.model.ModelMetadata.wrap(item))
      .provideEnvironment(r)
    def listModelsPaginated(
        request: ListModelsRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest,
        ListModelsResponse
      ]("listModels", api.listModels)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.ListModelsResponse.wrap)
        .provideEnvironment(r)
    def createModel(
        request: CreateModelRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest,
        CreateModelResponse
      ]("createModel", api.createModel)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.CreateModelResponse.wrap)
        .provideEnvironment(r)
    def updateDatasetEntries(request: UpdateDatasetEntriesRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest,
      UpdateDatasetEntriesResponse
    ]("updateDatasetEntries", api.updateDatasetEntries)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.wrap)
      .provideEnvironment(r)
    def describeDataset(request: DescribeDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest,
      DescribeDatasetResponse
    ]("describeDataset", api.describeDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def listProjects(request: ListProjectsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest,
      ListProjectsResponse,
      ProjectMetadata
    ](
      "listProjects",
      api.listProjects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.projects().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutvision.model.ProjectMetadata.wrap(item))
      .provideEnvironment(r)
    def listProjectsPaginated(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def deleteModel(
        request: DeleteModelRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest,
        DeleteModelResponse
      ]("deleteModel", api.deleteModel)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.DeleteModelResponse.wrap)
        .provideEnvironment(r)
    def stopModel(
        request: StopModelRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.StopModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.StopModelRequest,
        StopModelResponse
      ]("stopModel", api.stopModel)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.StopModelResponse.wrap)
        .provideEnvironment(r)
    def describeModelPackagingJob(
        request: DescribeModelPackagingJobRequest
    ): IO[
      AwsError,
      zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest,
      DescribeModelPackagingJobResponse
    ]("describeModelPackagingJob", api.describeModelPackagingJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.wrap)
      .provideEnvironment(r)
    def startModelPackagingJob(request: StartModelPackagingJobRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest,
      StartModelPackagingJobResponse
    ]("startModelPackagingJob", api.startModelPackagingJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutvision.model.StartModelPackagingJobResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(request: CreateProjectRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.CreateProjectRequest,
      CreateProjectResponse
    ]("createProject", api.createProject)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.CreateProjectResponse.wrap)
      .provideEnvironment(r)
    def startModel(
        request: StartModelRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.StartModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.StartModelRequest,
        StartModelResponse
      ]("startModel", api.startModel)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.StartModelResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeProject(request: DescribeProjectRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest,
      DescribeProjectResponse
    ]("describeProject", api.describeProject)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.DescribeProjectResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.lookoutvision.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.lookoutvision.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def detectAnomalies(
        request: DetectAnomaliesRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly
    ] = asyncRequestInputStream[
      software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest,
      DetectAnomaliesResponse
    ]("detectAnomalies", api.detectAnomalies)(request.buildAwsValue(), body)
      .map(zio.aws.lookoutvision.model.DetectAnomaliesResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(request: DeleteDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.DeleteDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest,
      DeleteDatasetResponse
    ]("deleteDataset", api.deleteDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.DeleteDatasetResponse.wrap)
      .provideEnvironment(r)
    def listModelPackagingJobs(request: ListModelPackagingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest,
      ListModelPackagingJobsResponse,
      ModelPackagingJobMetadata
    ](
      "listModelPackagingJobs",
      api.listModelPackagingJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelPackagingJobs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutvision.model.ModelPackagingJobMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listModelPackagingJobsPaginated(
        request: ListModelPackagingJobsRequest
    ): IO[
      AwsError,
      zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest,
      ListModelPackagingJobsResponse
    ]("listModelPackagingJobs", api.listModelPackagingJobs)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.wrap)
      .provideEnvironment(r)
    def deleteProject(request: DeleteProjectRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest,
      DeleteProjectResponse
    ]("deleteProject", api.deleteProject)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.DeleteProjectResponse.wrap)
      .provideEnvironment(r)
    def describeModel(request: DescribeModelRequest): IO[
      AwsError,
      zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest,
      DescribeModelResponse
    ]("describeModel", api.describeModel)(request.buildAwsValue())
      .map(zio.aws.lookoutvision.model.DescribeModelResponse.wrap)
      .provideEnvironment(r)
  }
  def listDatasetEntries(
      request: ListDatasetEntriesRequest
  ): ZStream[zio.aws.lookoutvision.LookoutVision, AwsError, DatasetEntry] =
    ZStream.serviceWithStream(_.listDatasetEntries(request))
  def listDatasetEntriesPaginated(request: ListDatasetEntriesRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetEntriesPaginated(request))
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listModels(request: ListModelsRequest): ZStream[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listModels(request))
  def listModelsPaginated(request: ListModelsRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelsPaginated(request))
  def createModel(request: CreateModelRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def updateDatasetEntries(request: UpdateDatasetEntriesRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatasetEntries(request))
  def describeDataset(request: DescribeDatasetRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def listProjects(request: ListProjectsRequest): ZStream[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(request: ListProjectsRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def deleteModel(request: DeleteModelRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteModel(request))
  def stopModel(request: StopModelRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.StopModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopModel(request))
  def describeModelPackagingJob(request: DescribeModelPackagingJobRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelPackagingJob(request))
  def startModelPackagingJob(request: StartModelPackagingJobRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startModelPackagingJob(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.lookoutvision.LookoutVision, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def startModel(request: StartModelRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.StartModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startModel(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeProject(request: DescribeProjectRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def detectAnomalies(
      request: DetectAnomaliesRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectAnomalies(request, body))
  def deleteDataset(request: DeleteDatasetRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def listModelPackagingJobs(request: ListModelPackagingJobsRequest): ZStream[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelPackagingJobs(request))
  def listModelPackagingJobsPaginated(
      request: ListModelPackagingJobsRequest
  ): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelPackagingJobsPaginated(request))
  def deleteProject(request: DeleteProjectRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def describeModel(request: DescribeModelRequest): ZIO[
    zio.aws.lookoutvision.LookoutVision,
    AwsError,
    zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModel(request))
}
