package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait TargetPlatformAccelerator {
  def unwrap: software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator
}
object TargetPlatformAccelerator {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator
  ): zio.aws.lookoutvision.model.TargetPlatformAccelerator = value match {
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator.NVIDIA =>
      val r = NVIDIA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator.UNKNOWN_TO_SDK_VERSION
  }
  case object NVIDIA
      extends zio.aws.lookoutvision.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformAccelerator.NVIDIA
  }
}
