package zio.aws.lookoutvision.model
import java.time.Instant
import zio.aws.lookoutvision.model.primitives.{
  IsLabeled,
  ProjectName,
  AnomalyClassFilter,
  DateTime,
  DatasetType,
  PaginationToken,
  QueryString,
  PageSize
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetEntriesRequest(
    projectName: ProjectName,
    datasetType: DatasetType,
    labeled: Option[IsLabeled] = None,
    anomalyClass: Option[AnomalyClassFilter] = None,
    beforeCreationDate: Option[DateTime] = None,
    afterCreationDate: Option[DateTime] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PageSize] = None,
    sourceRefContains: Option[QueryString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest = {
    import ListDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .optionallyWith(
        labeled.map(value => IsLabeled.unwrap(value): java.lang.Boolean)
      )(_.labeled)
      .optionallyWith(
        anomalyClass.map(value =>
          AnomalyClassFilter.unwrap(value): java.lang.String
        )
      )(_.anomalyClass)
      .optionallyWith(
        beforeCreationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.beforeCreationDate)
      .optionallyWith(
        afterCreationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.afterCreationDate)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        sourceRefContains.map(value =>
          QueryString.unwrap(value): java.lang.String
        )
      )(_.sourceRefContains)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ListDatasetEntriesRequest.ReadOnly =
    zio.aws.lookoutvision.model.ListDatasetEntriesRequest.wrap(buildAwsValue())
}
object ListDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListDatasetEntriesRequest =
      zio.aws.lookoutvision.model.ListDatasetEntriesRequest(
        projectName,
        datasetType,
        labeled.map(value => value),
        anomalyClass.map(value => value),
        beforeCreationDate.map(value => value),
        afterCreationDate.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        sourceRefContains.map(value => value)
      )
    def projectName: ProjectName
    def datasetType: DatasetType
    def labeled: Option[IsLabeled]
    def anomalyClass: Option[AnomalyClassFilter]
    def beforeCreationDate: Option[DateTime]
    def afterCreationDate: Option[DateTime]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PageSize]
    def sourceRefContains: Option[QueryString]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
    def getLabeled: ZIO[Any, AwsError, IsLabeled] =
      AwsError.unwrapOptionField("labeled", labeled)
    def getAnomalyClass: ZIO[Any, AwsError, AnomalyClassFilter] =
      AwsError.unwrapOptionField("anomalyClass", anomalyClass)
    def getBeforeCreationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("beforeCreationDate", beforeCreationDate)
    def getAfterCreationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("afterCreationDate", afterCreationDate)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSourceRefContains: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("sourceRefContains", sourceRefContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest
  ) extends zio.aws.lookoutvision.model.ListDatasetEntriesRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val datasetType: DatasetType =
      zio.aws.lookoutvision.model.primitives.DatasetType(impl.datasetType())
    override val labeled: Option[IsLabeled] = scala
      .Option(impl.labeled())
      .map(value => zio.aws.lookoutvision.model.primitives.IsLabeled(value))
    override val anomalyClass: Option[AnomalyClassFilter] = scala
      .Option(impl.anomalyClass())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.AnomalyClassFilter(value)
      )
    override val beforeCreationDate: Option[DateTime] = scala
      .Option(impl.beforeCreationDate())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val afterCreationDate: Option[DateTime] = scala
      .Option(impl.afterCreationDate())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lookoutvision.model.primitives.PageSize(value))
    override val sourceRefContains: Option[QueryString] = scala
      .Option(impl.sourceRefContains())
      .map(value => zio.aws.lookoutvision.model.primitives.QueryString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest
  ): zio.aws.lookoutvision.model.ListDatasetEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
