package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.ImageSourceType
import scala.jdk.CollectionConverters._
final case class ImageSource(`type`: Option[ImageSourceType] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ImageSource = {
    import ImageSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ImageSource
      .builder()
      .optionallyWith(
        `type`.map(value => ImageSourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ImageSource.ReadOnly =
    zio.aws.lookoutvision.model.ImageSource.wrap(buildAwsValue())
}
object ImageSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ImageSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ImageSource =
      zio.aws.lookoutvision.model.ImageSource(`type`.map(value => value))
    def `type`: Option[ImageSourceType]
    def getType: ZIO[Any, AwsError, ImageSourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ImageSource
  ) extends zio.aws.lookoutvision.model.ImageSource.ReadOnly {
    override val `type`: Option[ImageSourceType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ImageSourceType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ImageSource
  ): zio.aws.lookoutvision.model.ImageSource.ReadOnly = new Wrapper(impl)
}
