package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{
  ContentType,
  ModelVersion,
  ProjectName
}
import scala.jdk.CollectionConverters._
final case class DetectAnomaliesRequest(
    projectName: ProjectName,
    modelVersion: ModelVersion,
    contentType: ContentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest = {
    import DetectAnomaliesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.String)
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DetectAnomaliesRequest.ReadOnly =
    zio.aws.lookoutvision.model.DetectAnomaliesRequest.wrap(buildAwsValue())
}
object DetectAnomaliesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DetectAnomaliesRequest =
      zio.aws.lookoutvision.model
        .DetectAnomaliesRequest(projectName, modelVersion, contentType)
    def projectName: ProjectName
    def modelVersion: ModelVersion
    def contentType: ContentType
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest
  ) extends zio.aws.lookoutvision.model.DetectAnomaliesRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutvision.model.primitives.ModelVersion(impl.modelVersion())
    override val contentType: ContentType =
      zio.aws.lookoutvision.model.primitives.ContentType(impl.contentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DetectAnomaliesRequest
  ): zio.aws.lookoutvision.model.DetectAnomaliesRequest.ReadOnly = new Wrapper(
    impl
  )
}
