package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeModelResponse(
    modelDescription: Option[zio.aws.lookoutvision.model.ModelDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse = {
    import DescribeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse
      .builder()
      .optionallyWith(modelDescription.map(value => value.buildAwsValue()))(
        _.modelDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly =
    zio.aws.lookoutvision.model.DescribeModelResponse.wrap(buildAwsValue())
}
object DescribeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeModelResponse =
      zio.aws.lookoutvision.model
        .DescribeModelResponse(modelDescription.map(value => value.asEditable))
    def modelDescription
        : Option[zio.aws.lookoutvision.model.ModelDescription.ReadOnly]
    def getModelDescription: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelDescription.ReadOnly
    ] = AwsError.unwrapOptionField("modelDescription", modelDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse
  ) extends zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly {
    override val modelDescription
        : Option[zio.aws.lookoutvision.model.ModelDescription.ReadOnly] = scala
      .Option(impl.modelDescription())
      .map(value => zio.aws.lookoutvision.model.ModelDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelResponse
  ): zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
