package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  DateTime,
  ProjectName,
  ProjectArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProjectDescription(
    projectArn: Option[ProjectArn] = None,
    projectName: Option[ProjectName] = None,
    creationTimestamp: Option[DateTime] = None,
    datasets: Option[Iterable[zio.aws.lookoutvision.model.DatasetMetadata]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ProjectDescription = {
    import ProjectDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ProjectDescription
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ProjectDescription.ReadOnly =
    zio.aws.lookoutvision.model.ProjectDescription.wrap(buildAwsValue())
}
object ProjectDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ProjectDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ProjectDescription =
      zio.aws.lookoutvision.model.ProjectDescription(
        projectArn.map(value => value),
        projectName.map(value => value),
        creationTimestamp.map(value => value),
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def projectArn: Option[ProjectArn]
    def projectName: Option[ProjectName]
    def creationTimestamp: Option[DateTime]
    def datasets
        : Option[List[zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly]]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDatasets: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("datasets", datasets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ProjectDescription
  ) extends zio.aws.lookoutvision.model.ProjectDescription.ReadOnly {
    override val projectArn: Option[ProjectArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectArn(value))
    override val projectName: Option[ProjectName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectName(value))
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val datasets
        : Option[List[zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly]] =
      scala
        .Option(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.DatasetMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ProjectDescription
  ): zio.aws.lookoutvision.model.ProjectDescription.ReadOnly = new Wrapper(impl)
}
