package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    projects: Option[Iterable[zio.aws.lookoutvision.model.ProjectMetadata]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
      .builder()
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListProjectsResponse =
      zio.aws.lookoutvision.model.ListProjectsResponse(
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projects
        : Option[List[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getProjects: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("projects", projects)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ) extends zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly {
    override val projects
        : Option[List[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly]] =
      scala
        .Option(impl.projects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.ProjectMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ): zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
