package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{DatasetType, ProjectName}
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(
    projectName: ProjectName,
    datasetType: DatasetType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.lookoutvision.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeDatasetRequest =
      zio.aws.lookoutvision.model
        .DescribeDatasetRequest(projectName, datasetType)
    def projectName: ProjectName
    def datasetType: DatasetType
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest
  ) extends zio.aws.lookoutvision.model.DescribeDatasetRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val datasetType: DatasetType =
      zio.aws.lookoutvision.model.primitives.DatasetType(impl.datasetType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetRequest
  ): zio.aws.lookoutvision.model.DescribeDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
