package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  LookbackWindow,
  RetrainingFrequency,
  Timestamp,
  ModelName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateRetrainingSchedulerRequest(
    modelName: ModelName,
    retrainingStartDate: Optional[Timestamp] = Optional.Absent,
    retrainingFrequency: Optional[RetrainingFrequency] = Optional.Absent,
    lookbackWindow: Optional[LookbackWindow] = Optional.Absent,
    promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest = {
    import UpdateRetrainingSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        retrainingStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.retrainingStartDate)
      .optionallyWith(
        retrainingFrequency.map(value =>
          RetrainingFrequency.unwrap(value): java.lang.String
        )
      )(_.retrainingFrequency)
      .optionallyWith(
        lookbackWindow.map(value =>
          LookbackWindow.unwrap(value): java.lang.String
        )
      )(_.lookbackWindow)
      .optionallyWith(promoteMode.map(value => value.unwrap))(_.promoteMode)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest
      .wrap(buildAwsValue())
}
object UpdateRetrainingSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest =
      zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest(
        modelName,
        retrainingStartDate.map(value => value),
        retrainingFrequency.map(value => value),
        lookbackWindow.map(value => value),
        promoteMode.map(value => value)
      )
    def modelName: ModelName
    def retrainingStartDate: Optional[Timestamp]
    def retrainingFrequency: Optional[RetrainingFrequency]
    def lookbackWindow: Optional[LookbackWindow]
    def promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getRetrainingStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("retrainingStartDate", retrainingStartDate)
    def getRetrainingFrequency: ZIO[Any, AwsError, RetrainingFrequency] =
      AwsError.unwrapOptionField("retrainingFrequency", retrainingFrequency)
    def getLookbackWindow: ZIO[Any, AwsError, LookbackWindow] =
      AwsError.unwrapOptionField("lookbackWindow", lookbackWindow)
    def getPromoteMode
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelPromoteMode] =
      AwsError.unwrapOptionField("promoteMode", promoteMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val retrainingStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingStartDate())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val retrainingFrequency: Optional[RetrainingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingFrequency())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.RetrainingFrequency(value)
        )
    override val lookbackWindow: Optional[LookbackWindow] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookbackWindow())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LookbackWindow(value)
        )
    override val promoteMode
        : Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promoteMode())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelPromoteMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest
  ): zio.aws.lookoutequipment.model.UpdateRetrainingSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
