package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{IamRoleArn, ModelName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateModelRequest(
    modelName: ModelName,
    labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest = {
    import UpdateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.UpdateModelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateModelRequest.wrap(buildAwsValue())
}
object UpdateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.UpdateModelRequest =
      zio.aws.lookoutequipment.model.UpdateModelRequest(
        modelName,
        labelsInputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value)
      )
    def modelName: ModelName
    def labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def roleArn: Optional[IamRoleArn]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest
  ) extends zio.aws.lookoutequipment.model.UpdateModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest
  ): zio.aws.lookoutequipment.model.UpdateModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
