package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  DataDelayOffsetInMinutes,
  InferenceSchedulerIdentifier
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateInferenceSchedulerRequest(
    inferenceSchedulerName: InferenceSchedulerIdentifier,
    dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      Optional.Absent,
    dataUploadFrequency: Optional[
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = Optional.Absent,
    dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
    ] = Optional.Absent,
    dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest = {
    import UpdateInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest
      .builder()
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .optionallyWith(dataUploadFrequency.map(value => value.unwrap))(
        _.dataUploadFrequency
      )
      .optionallyWith(
        dataInputConfiguration.map(value => value.buildAwsValue())
      )(_.dataInputConfiguration)
      .optionallyWith(
        dataOutputConfiguration.map(value => value.buildAwsValue())
      )(_.dataOutputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object UpdateInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest(
        inferenceSchedulerName,
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency.map(value => value),
        dataInputConfiguration.map(value => value.asEditable),
        dataOutputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value)
      )
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes]
    def dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency]
    def dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ]
    def dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ]
    def roleArn: Optional[IamRoleArn]
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = AwsError.unwrapOptionField("dataUploadFrequency", dataUploadFrequency)
    def getDataInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataInputConfiguration",
      dataInputConfiguration
    )
    def getDataOutputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataOutputConfiguration",
      dataOutputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest.ReadOnly {
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
    override val dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataUploadFrequency())
        .map(value =>
          zio.aws.lookoutequipment.model.DataUploadFrequency.wrap(value)
        )
    override val dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputConfiguration.wrap(value)
      )
    override val dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataOutputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceOutputConfiguration.wrap(value)
      )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.UpdateInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
