package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersionArn,
  ModelVersion,
  ModelArn,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateActiveModelVersionResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    currentActiveVersion: Optional[ModelVersion] = Optional.Absent,
    previousActiveVersion: Optional[ModelVersion] = Optional.Absent,
    currentActiveVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    previousActiveVersionArn: Optional[ModelVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse = {
    import UpdateActiveModelVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        currentActiveVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.currentActiveVersion)
      .optionallyWith(
        previousActiveVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.previousActiveVersion)
      .optionallyWith(
        currentActiveVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.currentActiveVersionArn)
      .optionallyWith(
        previousActiveVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.previousActiveVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse
      .wrap(buildAwsValue())
}
object UpdateActiveModelVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse =
      zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        currentActiveVersion.map(value => value),
        previousActiveVersion.map(value => value),
        currentActiveVersionArn.map(value => value),
        previousActiveVersionArn.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def currentActiveVersion: Optional[ModelVersion]
    def previousActiveVersion: Optional[ModelVersion]
    def currentActiveVersionArn: Optional[ModelVersionArn]
    def previousActiveVersionArn: Optional[ModelVersionArn]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getCurrentActiveVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("currentActiveVersion", currentActiveVersion)
    def getPreviousActiveVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("previousActiveVersion", previousActiveVersion)
    def getCurrentActiveVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField(
        "currentActiveVersionArn",
        currentActiveVersionArn
      )
    def getPreviousActiveVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField(
        "previousActiveVersionArn",
        previousActiveVersionArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse
  ) extends zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val currentActiveVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentActiveVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val previousActiveVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousActiveVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val currentActiveVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentActiveVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val previousActiveVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousActiveVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse
  ): zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly =
    new Wrapper(impl)
}
