package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{ModelVersion, ModelName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateActiveModelVersionRequest(
    modelName: ModelName,
    modelVersion: ModelVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest = {
    import UpdateActiveModelVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.UpdateActiveModelVersionRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateActiveModelVersionRequest
      .wrap(buildAwsValue())
}
object UpdateActiveModelVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.UpdateActiveModelVersionRequest =
      zio.aws.lookoutequipment.model
        .UpdateActiveModelVersionRequest(modelName, modelVersion)
    def modelName: ModelName
    def modelVersion: ModelVersion
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest
  ) extends zio.aws.lookoutequipment.model.UpdateActiveModelVersionRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutequipment.model.primitives
        .ModelVersion(impl.modelVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest
  ): zio.aws.lookoutequipment.model.UpdateActiveModelVersionRequest.ReadOnly =
    new Wrapper(impl)
}
