package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait StatisticalIssueStatus {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus
}
object StatisticalIssueStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus
  ): zio.aws.lookoutequipment.model.StatisticalIssueStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.POTENTIAL_ISSUE_DETECTED =>
      val r = POTENTIAL_ISSUE_DETECTED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.NO_ISSUE_DETECTED =>
      val r = NO_ISSUE_DETECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.StatisticalIssueStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus =
      software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object POTENTIAL_ISSUE_DETECTED
      extends zio.aws.lookoutequipment.model.StatisticalIssueStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus =
      software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.POTENTIAL_ISSUE_DETECTED
  }
  case object NO_ISSUE_DETECTED
      extends zio.aws.lookoutequipment.model.StatisticalIssueStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus =
      software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus.NO_ISSUE_DETECTED
  }
}
