package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{ModelArn, ModelName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartRetrainingSchedulerResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse = {
    import StartRetrainingSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse
      .wrap(buildAwsValue())
}
object StartRetrainingSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse =
      zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        status.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse
  ): zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
