package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait RetrainingSchedulerStatus {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus
}
object RetrainingSchedulerStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus
  ): zio.aws.lookoutequipment.model.RetrainingSchedulerStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.RetrainingSchedulerStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus =
      software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.lookoutequipment.model.RetrainingSchedulerStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus =
      software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.PENDING
  }
  case object RUNNING
      extends zio.aws.lookoutequipment.model.RetrainingSchedulerStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus =
      software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.RUNNING
  }
  case object STOPPING
      extends zio.aws.lookoutequipment.model.RetrainingSchedulerStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus =
      software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.STOPPING
  }
  case object STOPPED
      extends zio.aws.lookoutequipment.model.RetrainingSchedulerStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus =
      software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus.STOPPED
  }
}
