package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{PolicyRevisionId, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyResponse(
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    policyRevisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.lookoutequipment.model.PutResourcePolicyResponse
      .wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.PutResourcePolicyResponse =
      zio.aws.lookoutequipment.model.PutResourcePolicyResponse(
        resourceArn.map(value => value),
        policyRevisionId.map(value => value)
      )
    def resourceArn: Optional[ResourceArn]
    def policyRevisionId: Optional[PolicyRevisionId]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse
  ) extends zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ResourceArn(value)
      )
    override val policyRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.PolicyRevisionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse
  ): zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
