package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IdempotenceToken,
  PolicyRevisionId,
  Policy,
  ResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    resourceArn: ResourceArn,
    resourcePolicy: Policy,
    policyRevisionId: Optional[PolicyRevisionId] = Optional.Absent,
    clientToken: IdempotenceToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourcePolicy(Policy.unwrap(resourcePolicy): java.lang.String)
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.lookoutequipment.model.PutResourcePolicyRequest
      .wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.PutResourcePolicyRequest =
      zio.aws.lookoutequipment.model.PutResourcePolicyRequest(
        resourceArn,
        resourcePolicy,
        policyRevisionId.map(value => value),
        clientToken
      )
    def resourceArn: ResourceArn
    def resourcePolicy: Policy
    def policyRevisionId: Optional[PolicyRevisionId]
    def clientToken: IdempotenceToken
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourcePolicy: ZIO[Any, Nothing, Policy] =
      ZIO.succeed(resourcePolicy)
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest
  ) extends zio.aws.lookoutequipment.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.lookoutequipment.model.primitives.ResourceArn(impl.resourceArn())
    override val resourcePolicy: Policy =
      zio.aws.lookoutequipment.model.primitives.Policy(impl.resourcePolicy())
    override val policyRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.PolicyRevisionId(value)
        )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest
  ): zio.aws.lookoutequipment.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
