package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonotonicValues(
    status: zio.aws.lookoutequipment.model.StatisticalIssueStatus,
    monotonicity: Optional[zio.aws.lookoutequipment.model.Monotonicity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.MonotonicValues = {
    import MonotonicValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.MonotonicValues
      .builder()
      .status(status.unwrap)
      .optionallyWith(monotonicity.map(value => value.unwrap))(_.monotonicity)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly =
    zio.aws.lookoutequipment.model.MonotonicValues.wrap(buildAwsValue())
}
object MonotonicValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.MonotonicValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.MonotonicValues =
      zio.aws.lookoutequipment.model
        .MonotonicValues(status, monotonicity.map(value => value))
    def status: zio.aws.lookoutequipment.model.StatisticalIssueStatus
    def monotonicity: Optional[zio.aws.lookoutequipment.model.Monotonicity]
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.StatisticalIssueStatus
    ] = ZIO.succeed(status)
    def getMonotonicity
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.Monotonicity] =
      AwsError.unwrapOptionField("monotonicity", monotonicity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.MonotonicValues
  ) extends zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly {
    override val status: zio.aws.lookoutequipment.model.StatisticalIssueStatus =
      zio.aws.lookoutequipment.model.StatisticalIssueStatus.wrap(impl.status())
    override val monotonicity
        : Optional[zio.aws.lookoutequipment.model.Monotonicity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monotonicity())
        .map(value => zio.aws.lookoutequipment.model.Monotonicity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.MonotonicValues
  ): zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly = new Wrapper(impl)
}
