package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersionArn,
  ModelArn,
  Timestamp,
  ModelVersion,
  ModelName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelVersionSummary(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    modelVersion: Optional[ModelVersion] = Optional.Absent,
    modelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      Optional.Absent,
    sourceType: Optional[
      zio.aws.lookoutequipment.model.ModelVersionSourceType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary = {
    import ModelVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.Long)
      )(_.modelVersion)
      .optionallyWith(
        modelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.modelVersionArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly =
    zio.aws.lookoutequipment.model.ModelVersionSummary.wrap(buildAwsValue())
}
object ModelVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ModelVersionSummary =
      zio.aws.lookoutequipment.model.ModelVersionSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        modelVersion.map(value => value),
        modelVersionArn.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        sourceType.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def modelVersion: Optional[ModelVersion]
    def modelVersionArn: Optional[ModelVersionArn]
    def createdAt: Optional[Timestamp]
    def status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus]
    def sourceType
        : Optional[zio.aws.lookoutequipment.model.ModelVersionSourceType]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField("modelVersionArn", modelVersionArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionSourceType
    ] = AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary
  ) extends zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
      )
    override val modelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionStatus.wrap(value)
        )
    override val sourceType
        : Optional[zio.aws.lookoutequipment.model.ModelVersionSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionSourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary
  ): zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
