package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait ModelVersionStatus {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus
}
object ModelVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus
  ): zio.aws.lookoutequipment.model.ModelVersionStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.IMPORT_IN_PROGRESS =>
      val r = IMPORT_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.IN_PROGRESS
  }
  case object SUCCESS
      extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.SUCCESS
  }
  case object FAILED extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.FAILED
  }
  case object IMPORT_IN_PROGRESS
      extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.IMPORT_IN_PROGRESS
  }
  case object CANCELED
      extends zio.aws.lookoutequipment.model.ModelVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus.CANCELED
  }
}
