package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait ModelVersionSourceType {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType
}
object ModelVersionSourceType {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType
  ): zio.aws.lookoutequipment.model.ModelVersionSourceType = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.TRAINING =>
      val r = TRAINING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.RETRAINING =>
      val r = RETRAINING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.IMPORT =>
      val r = IMPORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.ModelVersionSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAINING
      extends zio.aws.lookoutequipment.model.ModelVersionSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.TRAINING
  }
  case object RETRAINING
      extends zio.aws.lookoutequipment.model.ModelVersionSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.RETRAINING
  }
  case object IMPORT
      extends zio.aws.lookoutequipment.model.ModelVersionSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType =
      software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType.IMPORT
  }
}
