package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersionArn,
  DatasetArn,
  ModelArn,
  Timestamp,
  DatasetName,
  ModelVersion,
  ModelName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelSummary(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    activeModelVersion: Optional[ModelVersion] = Optional.Absent,
    activeModelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    latestScheduledRetrainingStatus: Optional[
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = Optional.Absent,
    latestScheduledRetrainingModelVersion: Optional[ModelVersion] =
      Optional.Absent,
    latestScheduledRetrainingStartTime: Optional[Timestamp] = Optional.Absent,
    nextScheduledRetrainingStartDate: Optional[Timestamp] = Optional.Absent,
    retrainingSchedulerStatus: Optional[
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ModelSummary = {
    import ModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        activeModelVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.activeModelVersion)
      .optionallyWith(
        activeModelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.activeModelVersionArn)
      .optionallyWith(
        latestScheduledRetrainingStatus.map(value => value.unwrap)
      )(_.latestScheduledRetrainingStatus)
      .optionallyWith(
        latestScheduledRetrainingModelVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.latestScheduledRetrainingModelVersion)
      .optionallyWith(
        latestScheduledRetrainingStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.latestScheduledRetrainingStartTime)
      .optionallyWith(
        nextScheduledRetrainingStartDate.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.nextScheduledRetrainingStartDate)
      .optionallyWith(retrainingSchedulerStatus.map(value => value.unwrap))(
        _.retrainingSchedulerStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ModelSummary.ReadOnly =
    zio.aws.lookoutequipment.model.ModelSummary.wrap(buildAwsValue())
}
object ModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ModelSummary =
      zio.aws.lookoutequipment.model.ModelSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        activeModelVersion.map(value => value),
        activeModelVersionArn.map(value => value),
        latestScheduledRetrainingStatus.map(value => value),
        latestScheduledRetrainingModelVersion.map(value => value),
        latestScheduledRetrainingStartTime.map(value => value),
        nextScheduledRetrainingStartDate.map(value => value),
        retrainingSchedulerStatus.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def status: Optional[zio.aws.lookoutequipment.model.ModelStatus]
    def createdAt: Optional[Timestamp]
    def activeModelVersion: Optional[ModelVersion]
    def activeModelVersionArn: Optional[ModelVersionArn]
    def latestScheduledRetrainingStatus
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus]
    def latestScheduledRetrainingModelVersion: Optional[ModelVersion]
    def latestScheduledRetrainingStartTime: Optional[Timestamp]
    def nextScheduledRetrainingStartDate: Optional[Timestamp]
    def retrainingSchedulerStatus
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getActiveModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("activeModelVersion", activeModelVersion)
    def getActiveModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField("activeModelVersionArn", activeModelVersionArn)
    def getLatestScheduledRetrainingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingStatus",
      latestScheduledRetrainingStatus
    )
    def getLatestScheduledRetrainingModelVersion
        : ZIO[Any, AwsError, ModelVersion] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingModelVersion",
      latestScheduledRetrainingModelVersion
    )
    def getLatestScheduledRetrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "latestScheduledRetrainingStartTime",
        latestScheduledRetrainingStartTime
      )
    def getNextScheduledRetrainingStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "nextScheduledRetrainingStartDate",
        nextScheduledRetrainingStartDate
      )
    def getRetrainingSchedulerStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = AwsError.unwrapOptionField(
      "retrainingSchedulerStatus",
      retrainingSchedulerStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ) extends zio.aws.lookoutequipment.model.ModelSummary.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val activeModelVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val activeModelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val latestScheduledRetrainingStatus
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingStatus())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionStatus.wrap(value)
        )
    override val latestScheduledRetrainingModelVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingModelVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val latestScheduledRetrainingStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val nextScheduledRetrainingStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextScheduledRetrainingStartDate())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val retrainingSchedulerStatus
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingSchedulerStatus())
        .map(value =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ): zio.aws.lookoutequipment.model.ModelSummary.ReadOnly = new Wrapper(impl)
}
