package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait ModelStatus {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.ModelStatus
}
object ModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.ModelStatus
  ): zio.aws.lookoutequipment.model.ModelStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.IMPORT_IN_PROGRESS =>
      val r = IMPORT_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.lookoutequipment.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.IN_PROGRESS
  }
  case object SUCCESS extends zio.aws.lookoutequipment.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.SUCCESS
  }
  case object FAILED extends zio.aws.lookoutequipment.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.FAILED
  }
  case object IMPORT_IN_PROGRESS
      extends zio.aws.lookoutequipment.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.ModelStatus =
      software.amazon.awssdk.services.lookoutequipment.model.ModelStatus.IMPORT_IN_PROGRESS
  }
}
