package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.AmazonResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListTagsForResourceRequest =
      zio.aws.lookoutequipment.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceArn
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest
  ) extends zio.aws.lookoutequipment.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceArn =
      zio.aws.lookoutequipment.model.primitives
        .AmazonResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest
  ): zio.aws.lookoutequipment.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
