package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRetrainingSchedulersResponse(
    retrainingSchedulerSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.RetrainingSchedulerSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse = {
    import ListRetrainingSchedulersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse
      .builder()
      .optionallyWith(
        retrainingSchedulerSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.retrainingSchedulerSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse
      .wrap(buildAwsValue())
}
object ListRetrainingSchedulersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse =
      zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse(
        retrainingSchedulerSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def retrainingSchedulerSummaries: Optional[
      List[zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getRetrainingSchedulerSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "retrainingSchedulerSummaries",
      retrainingSchedulerSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse
  ) extends zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly {
    override val retrainingSchedulerSummaries: Optional[
      List[zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.retrainingSchedulerSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse
  ): zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly =
    new Wrapper(impl)
}
