package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  MaxResults,
  NextToken,
  ModelName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRetrainingSchedulersRequest(
    modelNameBeginsWith: Optional[ModelName] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest = {
    import ListRetrainingSchedulersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest
      .builder()
      .optionallyWith(
        modelNameBeginsWith.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.modelNameBeginsWith)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest
      .wrap(buildAwsValue())
}
object ListRetrainingSchedulersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest =
      zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest(
        modelNameBeginsWith.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def modelNameBeginsWith: Optional[ModelName]
    def status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getModelNameBeginsWith: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelNameBeginsWith", modelNameBeginsWith)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest
  ) extends zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest.ReadOnly {
    override val modelNameBeginsWith: Optional[ModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelNameBeginsWith())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelName(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerStatus.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest
  ): zio.aws.lookoutequipment.model.ListRetrainingSchedulersRequest.ReadOnly =
    new Wrapper(impl)
}
