package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelVersionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    modelVersionSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.ModelVersionSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse = {
    import ListModelVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelVersionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelVersionSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListModelVersionsResponse
      .wrap(buildAwsValue())
}
object ListModelVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListModelVersionsResponse =
      zio.aws.lookoutequipment.model.ListModelVersionsResponse(
        nextToken.map(value => value),
        modelVersionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def modelVersionSummaries: Optional[
      List[zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelVersionSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("modelVersionSummaries", modelVersionSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse
  ) extends zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val modelVersionSummaries: Optional[
      List[zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.ModelVersionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse
  ): zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
