package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  NextToken,
  Timestamp,
  ModelVersion,
  MaxResults,
  ModelName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelVersionsRequest(
    modelName: ModelName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      Optional.Absent,
    sourceType: Optional[
      zio.aws.lookoutequipment.model.ModelVersionSourceType
    ] = Optional.Absent,
    createdAtEndTime: Optional[Timestamp] = Optional.Absent,
    createdAtStartTime: Optional[Timestamp] = Optional.Absent,
    maxModelVersion: Optional[ModelVersion] = Optional.Absent,
    minModelVersion: Optional[ModelVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest = {
    import ListModelVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(
        createdAtEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAtEndTime)
      .optionallyWith(
        createdAtStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAtStartTime)
      .optionallyWith(
        maxModelVersion.map(value => ModelVersion.unwrap(value): java.lang.Long)
      )(_.maxModelVersion)
      .optionallyWith(
        minModelVersion.map(value => ModelVersion.unwrap(value): java.lang.Long)
      )(_.minModelVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListModelVersionsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListModelVersionsRequest
      .wrap(buildAwsValue())
}
object ListModelVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListModelVersionsRequest =
      zio.aws.lookoutequipment.model.ListModelVersionsRequest(
        modelName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value),
        sourceType.map(value => value),
        createdAtEndTime.map(value => value),
        createdAtStartTime.map(value => value),
        maxModelVersion.map(value => value),
        minModelVersion.map(value => value)
      )
    def modelName: ModelName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus]
    def sourceType
        : Optional[zio.aws.lookoutequipment.model.ModelVersionSourceType]
    def createdAtEndTime: Optional[Timestamp]
    def createdAtStartTime: Optional[Timestamp]
    def maxModelVersion: Optional[ModelVersion]
    def minModelVersion: Optional[ModelVersion]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionSourceType
    ] = AwsError.unwrapOptionField("sourceType", sourceType)
    def getCreatedAtEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAtEndTime", createdAtEndTime)
    def getCreatedAtStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAtStartTime", createdAtStartTime)
    def getMaxModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("maxModelVersion", maxModelVersion)
    def getMinModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("minModelVersion", minModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest
  ) extends zio.aws.lookoutequipment.model.ListModelVersionsRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionStatus.wrap(value)
        )
    override val sourceType
        : Optional[zio.aws.lookoutequipment.model.ModelVersionSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionSourceType.wrap(value)
        )
    override val createdAtEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAtEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val createdAtStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAtStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val maxModelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.maxModelVersion())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
      )
    override val minModelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.minModelVersion())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest
  ): zio.aws.lookoutequipment.model.ListModelVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
