package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLabelsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    labelSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.LabelSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse = {
    import ListLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        labelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labelSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListLabelsResponse.wrap(buildAwsValue())
}
object ListLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListLabelsResponse =
      zio.aws.lookoutequipment.model.ListLabelsResponse(
        nextToken.map(value => value),
        labelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def labelSummaries
        : Optional[List[zio.aws.lookoutequipment.model.LabelSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLabelSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("labelSummaries", labelSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse
  ) extends zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val labelSummaries
        : Optional[List[zio.aws.lookoutequipment.model.LabelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.LabelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse
  ): zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
