package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  MaxResults,
  NextToken,
  LabelGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLabelGroupsRequest(
    labelGroupNameBeginsWith: Optional[LabelGroupName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest = {
    import ListLabelGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest
      .builder()
      .optionallyWith(
        labelGroupNameBeginsWith.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupNameBeginsWith)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListLabelGroupsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListLabelGroupsRequest.wrap(buildAwsValue())
}
object ListLabelGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListLabelGroupsRequest =
      zio.aws.lookoutequipment.model.ListLabelGroupsRequest(
        labelGroupNameBeginsWith.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def labelGroupNameBeginsWith: Optional[LabelGroupName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getLabelGroupNameBeginsWith: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField(
        "labelGroupNameBeginsWith",
        labelGroupNameBeginsWith
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest
  ) extends zio.aws.lookoutequipment.model.ListLabelGroupsRequest.ReadOnly {
    override val labelGroupNameBeginsWith: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupNameBeginsWith())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest
  ): zio.aws.lookoutequipment.model.ListLabelGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
