package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  MaxResults,
  NextToken,
  DatasetName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataIngestionJobsRequest(
    datasetName: Optional[DatasetName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.IngestionJobStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest = {
    import ListDataIngestionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest
      .wrap(buildAwsValue())
}
object ListDataIngestionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest =
      zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest(
        datasetName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def status: Optional[zio.aws.lookoutequipment.model.IngestionJobStatus]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionJobStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest
  ) extends zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.IngestionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.IngestionJobStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest
  ): zio.aws.lookoutequipment.model.ListDataIngestionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
