package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LargeTimestampGaps(
    status: zio.aws.lookoutequipment.model.StatisticalIssueStatus,
    numberOfLargeTimestampGaps: Optional[Integer] = Optional.Absent,
    maxTimestampGapInDays: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.LargeTimestampGaps = {
    import LargeTimestampGaps.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.LargeTimestampGaps
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        numberOfLargeTimestampGaps.map(value => value: java.lang.Integer)
      )(_.numberOfLargeTimestampGaps)
      .optionallyWith(
        maxTimestampGapInDays.map(value => value: java.lang.Integer)
      )(_.maxTimestampGapInDays)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly =
    zio.aws.lookoutequipment.model.LargeTimestampGaps.wrap(buildAwsValue())
}
object LargeTimestampGaps {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.LargeTimestampGaps
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.LargeTimestampGaps =
      zio.aws.lookoutequipment.model.LargeTimestampGaps(
        status,
        numberOfLargeTimestampGaps.map(value => value),
        maxTimestampGapInDays.map(value => value)
      )
    def status: zio.aws.lookoutequipment.model.StatisticalIssueStatus
    def numberOfLargeTimestampGaps: Optional[Integer]
    def maxTimestampGapInDays: Optional[Integer]
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.StatisticalIssueStatus
    ] = ZIO.succeed(status)
    def getNumberOfLargeTimestampGaps: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfLargeTimestampGaps",
        numberOfLargeTimestampGaps
      )
    def getMaxTimestampGapInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxTimestampGapInDays", maxTimestampGapInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LargeTimestampGaps
  ) extends zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly {
    override val status: zio.aws.lookoutequipment.model.StatisticalIssueStatus =
      zio.aws.lookoutequipment.model.StatisticalIssueStatus.wrap(impl.status())
    override val numberOfLargeTimestampGaps: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfLargeTimestampGaps())
        .map(value => value: Integer)
    override val maxTimestampGapInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxTimestampGapInDays())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LargeTimestampGaps
  ): zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly = new Wrapper(
    impl
  )
}
