package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  LabelGroupArn,
  Timestamp,
  FaultCode,
  Equipment,
  LabelGroupName,
  LabelId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LabelSummary(
    labelGroupName: Optional[LabelGroupName] = Optional.Absent,
    labelId: Optional[LabelId] = Optional.Absent,
    labelGroupArn: Optional[LabelGroupArn] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    rating: Optional[zio.aws.lookoutequipment.model.LabelRating] =
      Optional.Absent,
    faultCode: Optional[FaultCode] = Optional.Absent,
    equipment: Optional[Equipment] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.LabelSummary = {
    import LabelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.LabelSummary
      .builder()
      .optionallyWith(
        labelGroupName.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupName)
      .optionallyWith(
        labelId.map(value => LabelId.unwrap(value): java.lang.String)
      )(_.labelId)
      .optionallyWith(
        labelGroupArn.map(value =>
          LabelGroupArn.unwrap(value): java.lang.String
        )
      )(_.labelGroupArn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(rating.map(value => value.unwrap))(_.rating)
      .optionallyWith(
        faultCode.map(value => FaultCode.unwrap(value): java.lang.String)
      )(_.faultCode)
      .optionallyWith(
        equipment.map(value => Equipment.unwrap(value): java.lang.String)
      )(_.equipment)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.LabelSummary.ReadOnly =
    zio.aws.lookoutequipment.model.LabelSummary.wrap(buildAwsValue())
}
object LabelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.LabelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.LabelSummary =
      zio.aws.lookoutequipment.model.LabelSummary(
        labelGroupName.map(value => value),
        labelId.map(value => value),
        labelGroupArn.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        rating.map(value => value),
        faultCode.map(value => value),
        equipment.map(value => value),
        createdAt.map(value => value)
      )
    def labelGroupName: Optional[LabelGroupName]
    def labelId: Optional[LabelId]
    def labelGroupArn: Optional[LabelGroupArn]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def rating: Optional[zio.aws.lookoutequipment.model.LabelRating]
    def faultCode: Optional[FaultCode]
    def equipment: Optional[Equipment]
    def createdAt: Optional[Timestamp]
    def getLabelGroupName: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField("labelGroupName", labelGroupName)
    def getLabelId: ZIO[Any, AwsError, LabelId] =
      AwsError.unwrapOptionField("labelId", labelId)
    def getLabelGroupArn: ZIO[Any, AwsError, LabelGroupArn] =
      AwsError.unwrapOptionField("labelGroupArn", labelGroupArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getRating
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.LabelRating] =
      AwsError.unwrapOptionField("rating", rating)
    def getFaultCode: ZIO[Any, AwsError, FaultCode] =
      AwsError.unwrapOptionField("faultCode", faultCode)
    def getEquipment: ZIO[Any, AwsError, Equipment] =
      AwsError.unwrapOptionField("equipment", equipment)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelSummary
  ) extends zio.aws.lookoutequipment.model.LabelSummary.ReadOnly {
    override val labelGroupName: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
    override val labelId: Optional[LabelId] = zio.aws.core.internal
      .optionalFromNullable(impl.labelId())
      .map(value => zio.aws.lookoutequipment.model.primitives.LabelId(value))
    override val labelGroupArn: Optional[LabelGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.labelGroupArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.LabelGroupArn(value)
      )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val rating: Optional[zio.aws.lookoutequipment.model.LabelRating] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rating())
        .map(value => zio.aws.lookoutequipment.model.LabelRating.wrap(value))
    override val faultCode: Optional[FaultCode] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCode())
      .map(value => zio.aws.lookoutequipment.model.primitives.FaultCode(value))
    override val equipment: Optional[Equipment] = zio.aws.core.internal
      .optionalFromNullable(impl.equipment())
      .map(value => zio.aws.lookoutequipment.model.primitives.Equipment(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelSummary
  ): zio.aws.lookoutequipment.model.LabelSummary.ReadOnly = new Wrapper(impl)
}
