package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  LabelGroupArn,
  LabelGroupName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LabelGroupSummary(
    labelGroupName: Optional[LabelGroupName] = Optional.Absent,
    labelGroupArn: Optional[LabelGroupArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary = {
    import LabelGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary
      .builder()
      .optionallyWith(
        labelGroupName.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupName)
      .optionallyWith(
        labelGroupArn.map(value =>
          LabelGroupArn.unwrap(value): java.lang.String
        )
      )(_.labelGroupArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly =
    zio.aws.lookoutequipment.model.LabelGroupSummary.wrap(buildAwsValue())
}
object LabelGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.LabelGroupSummary =
      zio.aws.lookoutequipment.model.LabelGroupSummary(
        labelGroupName.map(value => value),
        labelGroupArn.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def labelGroupName: Optional[LabelGroupName]
    def labelGroupArn: Optional[LabelGroupArn]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getLabelGroupName: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField("labelGroupName", labelGroupName)
    def getLabelGroupArn: ZIO[Any, AwsError, LabelGroupArn] =
      AwsError.unwrapOptionField("labelGroupArn", labelGroupArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary
  ) extends zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly {
    override val labelGroupName: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
    override val labelGroupArn: Optional[LabelGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.labelGroupArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.LabelGroupArn(value)
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelGroupSummary
  ): zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly = new Wrapper(
    impl
  )
}
