package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DataDelayOffsetInMinutes,
  ModelArn,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceSchedulerSummary(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      Optional.Absent,
    dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      Optional.Absent,
    dataUploadFrequency: Optional[
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = Optional.Absent,
    latestInferenceResult: Optional[
      zio.aws.lookoutequipment.model.LatestInferenceResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary = {
    import InferenceSchedulerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .optionallyWith(dataUploadFrequency.map(value => value.unwrap))(
        _.dataUploadFrequency
      )
      .optionallyWith(latestInferenceResult.map(value => value.unwrap))(
        _.latestInferenceResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary
      .wrap(buildAwsValue())
}
object InferenceSchedulerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceSchedulerSummary =
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value),
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency.map(value => value),
        latestInferenceResult.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes]
    def dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency]
    def latestInferenceResult
        : Optional[zio.aws.lookoutequipment.model.LatestInferenceResult]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = AwsError.unwrapOptionField("dataUploadFrequency", dataUploadFrequency)
    def getLatestInferenceResult: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LatestInferenceResult
    ] =
      AwsError.unwrapOptionField("latestInferenceResult", latestInferenceResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ) extends zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
    override val dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataUploadFrequency())
        .map(value =>
          zio.aws.lookoutequipment.model.DataUploadFrequency.wrap(value)
        )
    override val latestInferenceResult
        : Optional[zio.aws.lookoutequipment.model.LatestInferenceResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestInferenceResult())
        .map(value =>
          zio.aws.lookoutequipment.model.LatestInferenceResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ): zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly =
    new Wrapper(impl)
}
