package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{S3Prefix, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceS3InputConfiguration(
    bucket: S3Bucket,
    prefix: Optional[S3Prefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration = {
    import InferenceS3InputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .optionallyWith(
        prefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceS3InputConfiguration
      .wrap(buildAwsValue())
}
object InferenceS3InputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.InferenceS3InputConfiguration =
      zio.aws.lookoutequipment.model
        .InferenceS3InputConfiguration(bucket, prefix.map(value => value))
    def bucket: S3Bucket
    def prefix: Optional[S3Prefix]
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration
  ) extends zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.lookoutequipment.model.primitives.S3Bucket(impl.bucket())
    override val prefix: Optional[S3Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.lookoutequipment.model.primitives.S3Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceS3InputConfiguration
  ): zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly =
    new Wrapper(impl)
}
