package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NameOrArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceOutputConfiguration(
    s3OutputConfiguration: zio.aws.lookoutequipment.model.InferenceS3OutputConfiguration,
    kmsKeyId: Optional[NameOrArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration = {
    import InferenceOutputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration
      .builder()
      .s3OutputConfiguration(s3OutputConfiguration.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => NameOrArn.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceOutputConfiguration
      .wrap(buildAwsValue())
}
object InferenceOutputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.InferenceOutputConfiguration =
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration(
        s3OutputConfiguration.asEditable,
        kmsKeyId.map(value => value)
      )
    def s3OutputConfiguration
        : zio.aws.lookoutequipment.model.InferenceS3OutputConfiguration.ReadOnly
    def kmsKeyId: Optional[NameOrArn]
    def getS3OutputConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.InferenceS3OutputConfiguration.ReadOnly
    ] = ZIO.succeed(s3OutputConfiguration)
    def getKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration
  ) extends zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly {
    override val s3OutputConfiguration
        : zio.aws.lookoutequipment.model.InferenceS3OutputConfiguration.ReadOnly =
      zio.aws.lookoutequipment.model.InferenceS3OutputConfiguration
        .wrap(impl.s3OutputConfiguration())
    override val kmsKeyId: Optional[NameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration
  ): zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly =
    new Wrapper(impl)
}
