package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  ComponentTimestampDelimiter,
  FileNameTimestampFormat
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceInputNameConfiguration(
    timestampFormat: Optional[FileNameTimestampFormat] = Optional.Absent,
    componentTimestampDelimiter: Optional[ComponentTimestampDelimiter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration = {
    import InferenceInputNameConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration
      .builder()
      .optionallyWith(
        timestampFormat.map(value =>
          FileNameTimestampFormat.unwrap(value): java.lang.String
        )
      )(_.timestampFormat)
      .optionallyWith(
        componentTimestampDelimiter.map(value =>
          ComponentTimestampDelimiter.unwrap(value): java.lang.String
        )
      )(_.componentTimestampDelimiter)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceInputNameConfiguration
      .wrap(buildAwsValue())
}
object InferenceInputNameConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.InferenceInputNameConfiguration =
      zio.aws.lookoutequipment.model.InferenceInputNameConfiguration(
        timestampFormat.map(value => value),
        componentTimestampDelimiter.map(value => value)
      )
    def timestampFormat: Optional[FileNameTimestampFormat]
    def componentTimestampDelimiter: Optional[ComponentTimestampDelimiter]
    def getTimestampFormat: ZIO[Any, AwsError, FileNameTimestampFormat] =
      AwsError.unwrapOptionField("timestampFormat", timestampFormat)
    def getComponentTimestampDelimiter
        : ZIO[Any, AwsError, ComponentTimestampDelimiter] =
      AwsError.unwrapOptionField(
        "componentTimestampDelimiter",
        componentTimestampDelimiter
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration
  ) extends zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly {
    override val timestampFormat: Optional[FileNameTimestampFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormat())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .FileNameTimestampFormat(value)
        )
    override val componentTimestampDelimiter
        : Optional[ComponentTimestampDelimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.componentTimestampDelimiter())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives
          .ComponentTimestampDelimiter(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceInputNameConfiguration
  ): zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly =
    new Wrapper(impl)
}
