package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.TimeZoneOffset
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceInputConfiguration(
    s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceS3InputConfiguration
    ] = Optional.Absent,
    inputTimeZoneOffset: Optional[TimeZoneOffset] = Optional.Absent,
    inferenceInputNameConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputNameConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration = {
    import InferenceInputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration
      .builder()
      .optionallyWith(s3InputConfiguration.map(value => value.buildAwsValue()))(
        _.s3InputConfiguration
      )
      .optionallyWith(
        inputTimeZoneOffset.map(value =>
          TimeZoneOffset.unwrap(value): java.lang.String
        )
      )(_.inputTimeZoneOffset)
      .optionallyWith(
        inferenceInputNameConfiguration.map(value => value.buildAwsValue())
      )(_.inferenceInputNameConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceInputConfiguration
      .wrap(buildAwsValue())
}
object InferenceInputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceInputConfiguration =
      zio.aws.lookoutequipment.model.InferenceInputConfiguration(
        s3InputConfiguration.map(value => value.asEditable),
        inputTimeZoneOffset.map(value => value),
        inferenceInputNameConfiguration.map(value => value.asEditable)
      )
    def s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly
    ]
    def inputTimeZoneOffset: Optional[TimeZoneOffset]
    def inferenceInputNameConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly
    ]
    def getS3InputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3InputConfiguration", s3InputConfiguration)
    def getInputTimeZoneOffset: ZIO[Any, AwsError, TimeZoneOffset] =
      AwsError.unwrapOptionField("inputTimeZoneOffset", inputTimeZoneOffset)
    def getInferenceInputNameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceInputNameConfiguration",
      inferenceInputNameConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration
  ) extends zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly {
    override val s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3InputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceS3InputConfiguration.wrap(value)
      )
    override val inputTimeZoneOffset: Optional[TimeZoneOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputTimeZoneOffset())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.TimeZoneOffset(value)
        )
    override val inferenceInputNameConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputNameConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceInputNameConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputNameConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration
  ): zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly =
    new Wrapper(impl)
}
